/***************************************************************************
 *
 * Copyright (c) 2014 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#ifndef _CALIBRATIONGETLOGICALCOORDINATECOMMAND_H_
#define _CALIBRATIONGETLOGICALCOORDINATECOMMAND_H_

#include <string>

#include "ICommand.h"
#include "CalibrationTypes.h"

class CalibrationGetLogicalCoordinateCommand : public ICommand
{
public:
    /*!
     * \action    This command converts a raw coordinate to a logical
     * coordinate related to a specific subdivision that the raw coordinate
     * corresponds to for a given input device, according to the device
     * calibration.
     * \frequency
     * \param[in] sender          Process id of application that sent this
     *                            command
     * \param[in] deviceName      Name of the input device
     * \param[in] raw             The raw coordinate to convert to logical
     * \param[in] subdivisionName Location to return the name of the
     *                            subdivision
     * \param[in] logical         Location to return the logical coordinate
     * \ingroup Commands
     */
    CalibrationGetLogicalCoordinateCommand(pid_t sender,
        std::string& deviceName, LayerManagerCalibration::coordinate* raw,
        std::string& subdivisionName, LayerManagerCalibration::coordinate* logical)
    : ICommand(ExecuteSynchronous, sender)
    , m_deviceName(deviceName)
    , m_raw(raw)
    , m_subdivisionName(subdivisionName)
    , m_logical(logical)
    {}

    /**
     * \brief default destructor
     */
    virtual ~CalibrationGetLogicalCoordinateCommand() {}

    /**
     * \brief Execute this command.
     * \param[in] executor Pointer to instance executing the LayerManagement Commands
     * \return ExecutionSuccess: execution successful
     * \return ExecutionFailed: execution failed
     */
    virtual ExecutionResult execute(ICommandExecutor* executor);

    /**
     * \brief Get description string for this command.
     * \return String object with description of this command object
     */
    virtual const std::string getString();

private:
    std::string m_deviceName;
    LayerManagerCalibration::coordinate* m_raw;
    std::string& m_subdivisionName;
    LayerManagerCalibration::coordinate* m_logical;

};

#endif // _CALIBRATIONGETLOGICALCOORDINATECOMMAND_H_
